#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/utsname.h>
#include <sys/time.h>

#include "../../shared/sockets.h"

#include "main.h"
#include "mode.h"
#include "chrono.h"

int TwentyFourHour=1;
int uptime_fd = 0;

static char kver[SYS_NMLN];
static char sysname[SYS_NMLN];

static double get_uptime(double *up, double *idle);


static double get_uptime(double *up, double *idle)
{
  double uptime;

  reread(uptime_fd, "get_uptime:");
  sscanf(buffer, "%lf %lf", &uptime, idle);

  *up = uptime;
  
  return uptime; 
}


// A couple of tables for later use...
static char *days[] = {
  "Sunday,   ",
  "Monday,   ",
  "Tuesday,  ",
  "Wednesday,",
  "Thursday, ",
  "Friday,   ",
  "Saturday, ",
};
static char *shortdays[] = {
  "Sun",
  "Mon",
  "Tue",
  "Wed",
  "Thu",
  "Fri",
  "Sat",
};

static char *months[] = {
  "  January",
  " February",
  "    March",
  "    April",
  "      May",
  "     June",
  "     July",
  "   August",
  "September",
  "  October",
  " November",
  " December",
};
static char *shortmonths[] = {
  "Jan",
  "Feb",
  "Mar",
  "Apr",
  "May",
  "Jun",
  "Jul",
  "Aug",
  "Sep",
  "Oct",
  "Nov",
  "Dec",
};



int chrono_init()
{
   struct utsname *unamebuf;
   
   if(!uptime_fd)
   {
      unamebuf = (struct utsname *) malloc( sizeof(struct utsname) );
      uptime_fd = open("/proc/uptime",O_RDONLY);
   
#if 0
      kversion_fd = open("/proc/sys/kernel/osrelease",O_RDONLY);
      
      reread(kversion_fd, "main:");
      sscanf(buffer, "%s", kver);
      
      close(kversion_fd);
# endif
   
      /* Get OS name and version from uname() */
      if( uname( unamebuf ) != 0 ) {
	 perror( "Error calling uname:" );
      }
      strcpy( kver, unamebuf->release );
      strcpy( sysname, unamebuf->sysname );
      
      free(unamebuf);


      
   }
   
   return 0;
}


int chrono_close()
{
   if(uptime_fd)
      close(uptime_fd);

   uptime_fd = 0;

   return 0;
}



//////////////////////////////////////////////////////////////////////
// Clock Screen displays current time and date...
//
int clock_screen(int rep, int display)
{
   char hr[8], min[8], sec[8], ampm[8];
   char day[16], month[16];
   static int first = 1;
   static int colons = 0;
   time_t thetime;
   struct tm *rtime;
   int i=0;
   
   if(first)
   {
      first = 0;
      
      sock_send_string(sock, "screen_add O\n");
      sprintf(buffer, "screen_set O name {Clock Screen: %s}\n", host);
      sock_send_string(sock, buffer);
      sock_send_string(sock, "widget_add O title title\n");
      sock_send_string(sock, "widget_set O title {DATE & TIME}\n");
      sock_send_string(sock, "widget_add O one string\n");
      sock_send_string(sock, "widget_add O two string\n");
      sock_send_string(sock, "widget_add O three string\n");
      sprintf(buffer, "widget_set O one 3 2 {%s}\n", host);
      sock_send_string(sock, buffer);
   }
   

   time(&thetime);
   rtime = localtime(&thetime);

   strcpy(day, days[rtime->tm_wday]);

   if(TwentyFourHour)
   {
      sprintf(hr, "%02d", rtime->tm_hour);
   }
   else
   {
     if (rtime->tm_hour > 12)
     {
        i = 1; sprintf(hr, "%02d", (rtime->tm_hour - 12));
     }
     else
     {
        i = 0; sprintf(hr, "%02d", rtime->tm_hour);
     }
   }
   if(rtime->tm_hour == 12) i=1;
   sprintf(min, "%02d", rtime->tm_min);
   sprintf(sec, "%02d", rtime->tm_sec);
   if (i == 1) { sprintf(ampm, "%s", "P"); } 
   else { sprintf(ampm, "%s", "A"); }
   strcpy(month, months[rtime->tm_mon]);


   sprintf(tmp,  "widget_set O two 1 3 {");
   if (colons)
   {
      if(TwentyFourHour)
         sprintf(tmp+strlen(tmp), "%s:%s:%s  %s", hr, min, sec, day);
      else
         sprintf(tmp+strlen(tmp), "%s:%s:%s%s %s", hr, min, sec, ampm, day);
   }
   else
   {
      if(TwentyFourHour)
         sprintf(tmp+strlen(tmp), "%s %s %s  %s", hr, min, sec, day);
      else
         sprintf(tmp+strlen(tmp), "%s %s %s%s %s", hr, min, sec, ampm, day); 
   }
   sprintf(tmp+strlen(tmp),  "}\n");
   if(display) sock_send_string(sock, tmp);


   sprintf(tmp,  "widget_set O three 2 4 {");
   sprintf(tmp+strlen(tmp),
	   "%s %d, %d",
	   month,
	   rtime->tm_mday,
	   (rtime->tm_year + 1900));
   sprintf(tmp+strlen(tmp),  "}\n");
   if(display) sock_send_string(sock, tmp);

   colons = colons ^ 1;
   
   return 0;
} // End clock_screen()



//////////////////////////////////////////////////////////////////////
// Big Clock Screen displays current time...
//
//Curses display is ugly, but should look nice on Matrix Orbital.
//
//+--------------------+
//|111555 444222 111333|
//|111555 444222 111333|
//|111555 444222 111333|
//|111555 444222 111333|
//+--------------------+
//
int big_clock_screen(int rep, int display)
{
   static int first = 1;
   static int colons = 0;
   time_t thetime;
   struct tm *rtime;
   int pos[]={1,4,8,11,15,18};
 //  int i=0;

   char fulltxt[16], old_fulltxt[16];
   int j=0;
   
   if(first)
   {
      first = 0;

      sock_send_string(sock, "screen_add K\n");
      sock_send_string(sock, "screen_set K name {Big Clock Screen}\n");
      sock_send_string(sock, "widget_del K heartbeat\n");
      sock_send_string(sock, "widget_add K d0 num\n");
      sock_send_string(sock, "widget_add K d1 num\n");
      sock_send_string(sock, "widget_add K d2 num\n");
      sock_send_string(sock, "widget_add K d3 num\n");
      sock_send_string(sock, "widget_add K d4 num\n");
      sock_send_string(sock, "widget_add K d5 num\n");
//      sock_send_string(sock, "widget_add K one string\n");
      sock_send_string(sock, "widget_set K d0 1 0\n");
      sock_send_string(sock, "widget_set K d1 4 0\n");
      sock_send_string(sock, "widget_set K d2 8 0\n");
      sock_send_string(sock, "widget_set K d3 11 0\n");
      sock_send_string(sock, "widget_set K d4 15 0\n");
      sock_send_string(sock, "widget_set K d5 18 0\n");
      old_fulltxt[0]='0';
      old_fulltxt[1]='0';
      old_fulltxt[2]='0';
      old_fulltxt[3]='0';
      old_fulltxt[4]='0';
      old_fulltxt[5]='0';
      old_fulltxt[6]=0;
//      sock_send_string(sock, "widget_set K one 1 4 {000000}\n");
   }

   time(&thetime);
   rtime = localtime(&thetime);

//   sprintf(min, "%02d", rtime->tm_min);
//   sprintf(sec, "%02d", rtime->tm_sec);
//   if(TwentyFourHour) {
//      sprintf(fulltxt, "%02d%02d%02d", rtime->tm_hour, rtime->tm_min, rtime->tm_sec);
//   } else {
//     if (rtime->tm_hour > 12) {
//        i = 1;
//        sprintf(fulltxt, "%02d%02d%02d", (rtime->tm_hour - 12), rtime->tm_min, rtime->tm_sec);
//     } else {
//        i = 0;
//        sprintf(fulltxt, "%02d%02d%02d", rtime->tm_hour, rtime->tm_min, rtime->tm_sec);
//     }
//   }
//   if(rtime->tm_hour == 12) i=1;
//   if (i == 1) { sprintf(ampm, "%s", "P"); } 
//   else { sprintf(ampm, "%s", "A"); }

sprintf(fulltxt, "%02d%02d%02d", rtime->tm_hour, rtime->tm_min, rtime->tm_sec);
   for(j=0;j<6;j++){
      if (fulltxt[j]!=old_fulltxt[j]){
         sprintf(tmp+strlen(tmp), "widget_set K d%d %d %c\n", j, pos[j], fulltxt[j]);
         old_fulltxt[j]=fulltxt[j];
      }
   }

   if(display)
      sock_send_string(sock, tmp);

// This is for debugging only...
//printf("fulltxt[%d]=%c old_fulltxt[%d]=%c\n", j, fulltxt[j], j, old_fulltxt[j]);
//   sprintf(tmp, "widget_set K one 1 4 {%s}\n", fulltxt);
//   sock_send_string(sock, tmp);
// This was for debugging only...
// colons = colons ^ 1;

   return 0;
} // End big_clock_screen()


//////////////////////////////////////////////////////////////////////
// Time Screen displays current time and date, uptime, OS ver...
//
//+--------------------+
//|## Linux 2.0.33 ###@|
//|Up xxx days hh:mm:ss|
//|  Wed May 17, 1998  |
//|11:32:57a  100% idle|
//+--------------------+
//

int time_screen(int rep, int display)
{
   char hr[8], min[8], sec[8], ampm[8];
   char day[16], month[16];
   static int first = 1;
   static int colons = 0;
   time_t thetime;
   struct tm *rtime;
   double uptime, idle;
   int i = 0;



   if(first)
   {
      first = 0;

      sock_send_string(sock, "screen_add T\n");
      sprintf(buffer, "screen_set T name {Time Screen: %s}\n", host);
      sock_send_string(sock, buffer);
      sock_send_string(sock, "widget_add T title title\n");
      sock_send_string(sock, "widget_set T title {Time Screen}\n");
      sock_send_string(sock, "widget_add T one string\n");
      sock_send_string(sock, "widget_add T two string\n");
      sock_send_string(sock, "widget_add T three string\n");
   }


   get_uptime(&uptime, &idle);
   idle = (idle * 100) / uptime;

  
   ///////////////////// Write the title bar (os name and version)

   sprintf(tmp, "widget_set T title {");
   sprintf(tmp+strlen(tmp), "%s %s: %s}\n", 
	   sysname, kver, host);
   if(display) sock_send_string(sock, tmp);

   
   /////////////////////// Display the time...
   time(&thetime);
   rtime = localtime(&thetime);

   if(TwentyFourHour)
   {
      sprintf(hr, "%02d", rtime->tm_hour);
   }
   else
   {
      if (rtime->tm_hour > 12) 
      {
	 i = 1; sprintf(hr, "%02d", (rtime->tm_hour - 12));
      }
      else if(rtime->tm_hour == 0)
      {
         i = 0; sprintf(hr, "12");
      }
      else
      {
	 i = 0; sprintf(hr, "%02d", rtime->tm_hour);
      }
   }
   if(rtime->tm_hour == 12) i=1;
   if (i == 1) { sprintf(ampm, "%s", "P"); } 
   else { sprintf(ampm, "%s", "A"); }

   sprintf(min, "%02d", rtime->tm_min);
   sprintf(sec, "%02d", rtime->tm_sec);


   if (colons) 
   { 
      if(TwentyFourHour)
	 sprintf(tmp, "%s:%s:%s   %2i%% idle", hr, min, sec, (int)idle); 
      else
	 sprintf(tmp, "%s:%s:%s%s  %2i%% idle", hr, min, sec, ampm, (int)idle); 
   }
   else
   { 
      if(TwentyFourHour)
	 sprintf(tmp, "%s %s %s   %2i%% idle", hr, min, sec, (int)idle); 
      else
	 sprintf(tmp, "%s %s %s%s  %2i%% idle", hr, min, sec, ampm, (int)idle); 
   }
   // Center the output line...
   i = ((lcd_wid - strlen(tmp)) / 2) + 1;
   sprintf(buffer, "widget_set T three %i 4 {%s}\n", i, tmp);
   if(display) sock_send_string(sock, buffer);




   /////////////////////// Display the uptime...
   strcpy(day, shortdays[rtime->tm_wday]);
   strcpy(month, shortmonths[rtime->tm_mon]);

   sprintf(tmp, "%s %s %d, %d", day, month, 
	   rtime->tm_mday, (rtime->tm_year + 1900));
   sprintf(buffer, "widget_set T two 3 3 {%s}\n", tmp);
   if(display) sock_send_string(sock, buffer);


   i = (int)uptime / 86400;
   sprintf(day, "%d day%s,", i, (i != 1 ? "s" : ""));
   i = ((int)uptime % 86400) / 60 / 60;
   sprintf(hr, "%02i",i);
   i = (((int)uptime % 86400) % 3600) / 60;
   sprintf(min, "%02i",i);
   i = ((int)uptime % 60);
   sprintf(sec, "%02i",i);
   if (colons)
      sprintf(tmp, "%s %s:%s:%s", day, hr, min, sec);
   else
      sprintf(tmp, "%s %s %s %s", day, hr, min, sec);
   // Center this line automatically...
   i = ((lcd_wid - strlen(tmp)) / 2) + 1;
   sprintf(buffer, "widget_set T one %i 2 {%s}", i, tmp);
   if(display) sock_send_string(sock, buffer);

   
   colons = colons ^ 1;
   
   return 0;
} // End time_screen()



////////////////////////////////////////////////////////////////////
// Uptime Screen shows info about system uptime and OS version
//
int uptime_screen(int rep, int display)
{
   int i;
   char date[16], hour[8], min[8], sec[8];
   double uptime, idle;
   static int first = 1;
   static int colons = 0;
  

   if(first)
   {
      first = 0;

      sock_send_string(sock, "screen_add U\n");
      sprintf(buffer, "screen_set U name {Uptime Screen: %s}\n", host);
      sock_send_string(sock, buffer);
      sock_send_string(sock, "widget_add U title title\n");
      sock_send_string(sock, "widget_set U title {SYSTEM UPTIME}\n");
      sock_send_string(sock, "widget_add U one string\n");
      sock_send_string(sock, "widget_add U two string\n");
      sock_send_string(sock, "widget_add U three string\n");

      sprintf(buffer, "widget_set U one 3 2 {%s}\n", host);
      sock_send_string(sock, buffer);
      sprintf(tmp, "widget_set U three 5 4 {%s %s}\n", sysname, kver);
      sock_send_string(sock, tmp);
   }

   get_uptime(&uptime, &idle);
   i = (int)uptime / 86400;
   sprintf(date, "%d day%s,", i, (i != 1 ? "s" : ""));
   i = ((int)uptime % 86400) / 60 / 60;
   sprintf(hour, "%02i",i);
   i = (((int)uptime % 86400) % 3600) / 60;
   sprintf(min, "%02i",i);
   i = ((int)uptime % 60);
   sprintf(sec, "%02i",i);
   if (colons)
      sprintf(tmp, "%s %s:%s:%s", date, hour, min, sec);
   else
      sprintf(tmp, "%s %s %s %s", date, hour, min, sec);
   i = ((20 - strlen(tmp)) / 2) + 1;

   sprintf(buffer, "widget_set U two %i 3 {%s}\n", i, tmp);
   if(display) sock_send_string(sock, buffer);

   colons = colons ^ 1;
   
   return 0;
} // End uptime_screen()

