#include "config.h"


typedef struct command
{
      char *text;
      struct command *child;
      int (*func)(char *line);
};

command main_list[] = {
   "Key",           NULL,           Key_func,
   "Driver",        Driver_commands,NULL,
   NULL,            NULL,           NULL,
};

command Driver_commands[] = {
   "MtxOrb",        NULL,           MtxOrb_drv_init,
   "curses",        NULL,           curses_drv_init,
   "hd44780",       NULL,           hd44780_drv_init,
//   "X11",           NULL,           X11_drv_init,
   "debug",         NULL,           debug_drv_init,
   "text",          NULL,           text_drv_init,
};



// Interpret a line...
int parse_line(char *line);
// Interpret the rest of the line...
int parse_rest(char *line, command *commands);


////////// Helper functions for line parsing /////////////////
// Pops off the first word of the string.
char *shift(char *string);


////////////// Config Functions /////////////////////////////////
int Key_func(char *line)
{
   // uh, interpret the command...
   return 0;
}
