/*
  render.c

  Draws screens on the LCD.

  This needs to be greatly expanded and redone for greater flexibility.
  For example, it should support multiple screen sizes, more flexible
  widgets, and multiple simultaneous screens.

  This will probably take a while to do.  :(
  
 */


#include <string.h>
#include <stdio.h>

#include "../shared/debug.h"
#include "../shared/LL.h"

#include "drivers/lcd.h"

#include "screen.h"
#include "screenlist.h"
#include "widget.h"
#include "render.h"



int heartbeat=HEART_OPEN;
int backlight=BACKLIGHT_OPEN;

#define BUFSIZE 1024

int draw_screen(screen *s, int timer)
{
   char str[BUFSIZE];
   widget *w;
   static screen *old_s=NULL;
   
   int x, y;
   //int wid, hgt;
   int length, speed;
   //int lines;
   
   int reset = 1;

   //debug("draw_screen: %8x, %i\n", s, timer);
   
   if(!s) return -1;

   if(s == old_s) reset = 0;
   old_s = s;
   

   lcd.clear();
   
   //debug("draw_screen: %8x, %i\n", s, timer);
   
   LL_Rewind(s->widgets);
   do {
      w = (widget *)LL_Get(s->widgets);
      if(!w) return -1;

      switch(w->type)
      {
	 case WID_STRING:
	    if((w->x > 0) && (w->y > 0) && (w->text))
	    {
	       lcd.string(w->x, w->y, w->text);
	    }
	    break;
	 case WID_HBAR:
	    if(reset)
	    {
	       lcd.init_hbar();
	       reset = 0;
	    }
	    if((w->x > 0) && (w->y > 0))
	    {
	       if(w->length > 0)
	       {
		  lcd.hbar(w->x, w->y, w->length);
	       }
	       else if(w->length < 0)
	       {
		  // TODO:  Rearrange stuff to get left-extending
		  // hbars to draw correctly...
		  // .. er, this'll require driver modifications,
		  // so I'll leave it out for now.
	       }
	    }
	    break;
	 case WID_VBAR:
	    if(reset)
	    {
	       lcd.init_vbar();
	       reset = 0;
	    }
	    if((w->x > 0) && (w->y > 0))
	    {
	       if(w->length > 0)
	       {
		  lcd.vbar(w->x, w->length);
	       }
	       else if(w->length < 0)
	       {
		  // TODO:  Rearrange stuff to get down-extending
		  // vbars to draw correctly...
		  // .. er, this'll require driver modifications,
		  // so I'll leave it out for now.
	       }
	    }
	    break;
	 case WID_ICON:
	    break;
	 case WID_TITLE:
	    if(!w->text) break;
	    
	    memset(str, 255, 20);
	    str[2] = ' ';
	    length = strlen(w->text);
	    if(length <= 14)
	    {
	       memcpy(str+3, w->text, length);
	       str[length+3] = ' ';
	    }
	    else // Scroll the title, if it doesn't fit...
	    {
	       speed = 1;
	       x = timer / speed;
	       y = x / length;

	       // Make sure the whole title gets displayed, at least...
	       if(!screenlist_action) screenlist_action = RENDER_HOLD;
	       if(x > length - 6)
	       {
		  // Release hold after it has been displayed
		  if(!screenlist_action  ||  screenlist_action == RENDER_HOLD)
		     screenlist_action = 0;
	       }
	       x %= (length);
	       x -= 3;
	       if(x < 0) x = 0;
	       if(x > length - 14) x = length - 14;
	       
	       if(y&1) // Scrolling backwards...
	       {
		  x = (length-14) - x;
	       }
	       strncpy(str+3, w->text+x, 14);
	       str[lcd.wid-3] = ' ';
	    }
	    str[lcd.wid] = 0;
	    
	    lcd.string(1,1,str);
	    break;
	 case WID_SCROLLER:
	 {
	      int offset;
	      int screen_width;
	      if (!w->text) break;
	      if (w->right < w->left) break;
	      //printf("rendering: %s %d\n",w->text,timer);
	      screen_width = w->right - w->left + 1;
	      switch (w->length)
	      { // actually, direction...
		 // FIXME:  Horz scrollers don't show the
		 // last letter in the string...  (1-off error?)
		 case 'h':
		    length = strlen(w->text);
		    if (length <= screen_width)
		    {
		       /* it fits within the box, just render it */
		       lcd.string(w->left,w->top,w->text);
		    }
		    else
		    {
		       int effLength = length - screen_width;
		       int necessaryTimeUnits = 0;
		       if (!screenlist_action) screenlist_action = RENDER_HOLD;
		       if (w->speed > 0) {
			  necessaryTimeUnits = effLength * w->speed;
			  if (((timer / (effLength*w->speed)) % 2) == 0) {
			     //wiggle one way
			     offset = (timer % (effLength*w->speed))
				/ w->speed;
			  }
			  else
			  {
			     //wiggle the other
			     offset = (((timer % (effLength*w->speed))
					- (effLength*w->speed) + 1)
				       / w->speed) * -1;
			  }
		       }
		       else if (w->speed < 0)
		       {
			  necessaryTimeUnits = effLength / (w->speed * -1);
			  if (((timer / (effLength/(w->speed*-1))) % 2) == 0)
			  {
			     offset = (timer % (effLength/(w->speed*-1)))
				* w->speed * -1;
			  }
			  else
			  {
			     offset = (((timer % (effLength/(w->speed*-1)))
					* w->speed * -1) - effLength + 1) * -1;
			  }
		       }
		       else
		       {
			  offset = 0;
			  if(screenlist_action == RENDER_HOLD)
			     screenlist_action = 0;
		       }
		       if (timer > necessaryTimeUnits)
		       {
			  if(screenlist_action == RENDER_HOLD)
			     screenlist_action = 0;
		       }
		       if (offset <= length)
		       {
			  strncpy(str,&((w->text)[offset]),screen_width);
			  str[screen_width] = '\0';
			  //printf("%s : %d\n",str,length-offset);
		       }
		       else
		       {
			  str[0] = '\0';
		       }
		       lcd.string(w->left,w->top,str);
		    }
		    break;
		 // FIXME:  Vert scrollers don't always seem to scroll
                 // back up after hitting the bottom.  They jump back to
                 // the top instead...  (nevermind?)
		 case 'v':
		 {
		    int i=0;
		    length = strlen(w->text);
		    if (length <= screen_width)
		    {
		       /* no scrolling required...*/
		       lcd.string(w->left,w->top,w->text);
		    }
		    else
		    {
		       int lines_required =
			  (length / screen_width)
			  + (length % screen_width ? 1 : 0);
		       int available_lines = (w->bottom - w->top + 1);
		       if (lines_required <= available_lines)
		       {
			  // easy...
			  for(i=0;i<lines_required;i++)
			  {
			     strncpy(str,
				     &((w->text)[i*screen_width]),
				     screen_width);
			     str[screen_width] = '\0';
			     lcd.string(w->left,w->top + i,str);
			  }
		       }
		       else
		       {
			  int necessaryTimeUnits = 0;
			  int effLines = lines_required - available_lines + 1;
			  int begin = 0;
			  if (!screenlist_action)
			     screenlist_action = RENDER_HOLD;
			  //printf("length: %d sw: %d lines req: %d  avail lines: %d  effLines: %d \n",length,screen_width,lines_required,available_lines,effLines);
			  if (w->speed > 0)
			  {
			     necessaryTimeUnits = effLines * w->speed;
			     if (((timer / (effLines*w->speed)) % 2) == 0)
			     {
				//printf("up ");
				begin = (timer % (effLines*w->speed))
				   / w->speed;
			     }
			     else
			     {
				//printf("down ");
				begin = (((timer % (effLines*w->speed))
					  - (effLines*w->speed) + 1)/w->speed)
				   * -1;
			     }
			  }
			  else if (w->speed < 0)
			  {
			     necessaryTimeUnits = effLines / (w->speed * -1);
			     if (((timer / (effLines/(w->speed*-1))) % 2) == 0)
			     {
				begin = (timer % (effLines/(w->speed*-1)))
				   * w->speed * -1;
			     }
			     else
			     {
				begin = (((timer % (effLines/(w->speed*-1)))
					  * w->speed * -1) - effLines + 1)
				   * -1;
			     }
			  }
			  else
			  {
			     begin = 0;
			  }
			  //printf("rendering begin: %d  timer: %d effLines: %d\n",begin,timer,effLines);
			  for(i=begin;i<begin+available_lines;i++)
			  {
			     strncpy(str,
				     &((w->text)[i*(screen_width)]),
				     screen_width);
			     str[screen_width] = '\0';
			     //printf("rendering: '%s' of %s\n",
			     //str,w->text);
			     lcd.string(w->left,w->top + (i-begin),str);
			  }
			  if (timer > necessaryTimeUnits)
			  {
			     if(screenlist_action == RENDER_HOLD)
				screenlist_action = 0;
			  }
		       }
		    }
		    break;
		 }
	      }
	      break;
	 }
	 case WID_NONE:
	 default:
	    break;
      }
   } while(LL_Next(s->widgets) == 0);

   
   
   if(heartbeat)
   {
      if(s->heartbeat  ||  heartbeat == HEART_ON)
      {
	 // Set this to pulsate like a real heart beat...
	 // (binary is fun...  :)
	 lcd.icon(!((timer+4)&5), 0);
	 lcd.chr(lcd.wid, 1, 0);
      }
   }
   
   lcd.flush();
   
   //debug("draw_screen: %8x, %i\n", s, timer);

   return 0;
}

