#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef LINUX
#include <sys/vfs.h>
#else
#include <sys/statfs.h>
#endif


#include "../../shared/sockets.h"

#include "main.h"
#include "mode.h"
#include "disk.h"

FILE *mtab_fd;


typedef struct mounts 
{ 
  char dev[256], type[64], mpoint[256];
  long bsize, blocks, bfree, files, ffree; 
} mounts;


static int get_fs(mounts fs[])
{
  struct statfs fsinfo;
  char line[256];
  int x = 0, y;
  
  mtab_fd = fopen("/etc/mtab", "r");

  // Get rid of old, unmounted filesystems...
  memset(fs, 0, sizeof(mounts)*256);
  
  while (x < 256)
  {
    if(fgets(line, 256, mtab_fd) == NULL)
      {
	fclose(mtab_fd);
	return x;
      }
    
    sscanf(line, "%s %s %s", fs[x].dev, fs[x].mpoint, fs[x].type);
    
    if(   strcmp(fs[x].type, "proc")
#ifndef STAT_NFS
       && strcmp(fs[x].type, "nfs")
#endif
#ifndef STAT_SMBFS
       && strcmp(fs[x].type, "smbfs")
#endif
      ) 
    {
#ifdef LINUX
      y = statfs(fs[x].mpoint, &fsinfo); 
#else
      y = statfs(fs[x].mpoint, &fsinfo, sizeof(fsinfo), 0); 
#endif
      fs[x].bsize = fsinfo.f_bsize; 
      fs[x].blocks = fsinfo.f_blocks;
      fs[x].bfree = fsinfo.f_bfree; 
      fs[x].files = fsinfo.f_files;
      fs[x].ffree = fsinfo.f_ffree; 
      x++;
    }
  }

  fclose(mtab_fd);
  return x;
}



int disk_init()
{

   return 0;
}

int disk_close()
{

   return 0;
}


///////////////////////////////////////////////////////////////////////////
// Gives disk stats. 
//
// Stays onscreen until it is done.
//

// TODO: Disk screen!  Requires virtual pages in the server, though...

int disk_screen(int rep, int display)
{
#if 0
   static mounts mnt[256]; 
  static int count=0;

  struct disp  // Holds info to display (avoid recalculating it)
  { 
    char dev[8]; 
    char cap[8];
    int full; 
  } table[256];
  int i, y;
  static int first=0;  // First line to display, sort of.

  #define huge long long int
  huge size;


  // Grab disk stats on first display, and fill "table".
  if(!rep) 
  {
    lcd.clear();
    lcd.init_hbar();
    lcd.icon(2,7);

    // Get rid of old, unmounted filesystems...
    memset(table, 0, sizeof(struct disp)*256);
    
    count = get_fs(mnt);
    first = 0;
    
    sprintf(tmp, "%c%c FILESYSTEMS %c%c%c%c", 
	    PAD, PAD, PAD, PAD, PAD, PAD);
    lcd.string(1, 1, tmp);

    // Fill the display structure...
    if(count)
    {
      for(i=0; i<count; i++)
      {
	if(strlen(mnt[i].mpoint) > 6)
	{
	  sprintf(table[i].dev, "%c%s", ELLIPSIS,
		  (mnt[i].mpoint)+(strlen(mnt[i].mpoint)-5));
	}
	else
	{
	  sprintf(table[i].dev, "%s", mnt[i].mpoint);
	}
	
	table[i].full = (lcd.cellwid * 4)
	              * (huge)(mnt[i].blocks - mnt[i].bfree)
	              / (huge)mnt[i].blocks;

	size = (huge)mnt[i].bsize * (huge)mnt[i].blocks;
	memset(table[i].cap, 0, 8);

	// Kilobytes
	if(size > 0  &&  size < (huge)1000*(huge)1000)
	  sprintf(table[i].cap, "%3.1fk", 
		  (double)(size)/1024.0);
	// Megabytes
	else if(size >= (huge)1000*(huge)1000
		&&  size < (huge)1000*(huge)1000*(huge)1000)
	  sprintf(table[i].cap, "%3.1fM", 
		  (float)(size/(huge)1024)/1024.0);
	// Gigabytes
	else if(size >= (huge)1000*(huge)1000*(huge)1000  
		&&  size < (huge)1000*(huge)1000*(huge)1000*(huge)1000)
	  sprintf(table[i].cap, "%3.1fG", 
		  (float)(size/((huge)1024*(huge)1024))/1024.0);
	// Terabytes
	else if(size >= (huge)1000*(huge)1000*(huge)1000*(huge)1000  
		&&  size < (huge)1000*(huge)1000*(huge)1000*(huge)1000*(huge)1000)
	  sprintf(table[i].cap, "%3.1fT", 
		  (float)(size/((huge)1024*(huge)1024*(huge)1024))/1024.0);
	  	
	// PectaBytes -- Yeah!  I want some!
	else if(size >= (huge)1000*(huge)1000*(huge)1000*(huge)1000*(huge)1000
		&&  size < (huge)1000*(huge)1000*(huge)1000*(huge)1000*(huge)1000*(huge)1000)
	  sprintf(table[i].cap, "%3.1fP", 
		  (float)(size/((huge)1024*(huge)1024*(huge)1024*(huge)1024))/1024.0);
	  	
      }
    }
  } // End if(!rep)


  // Increment this once per second.
  if((rep&7) == 0) first++;
  

  if (!count) 
  { 
    lcd.string(1, 2, "Error Retrieving");
    lcd.string(5, 3, "Filesystem Stats");
    return 0;
  }

  // If we are done, tell the system to keep going.
  if (first >= count+1)
    return CONTINUE;


  // Display stuff...  (show for two seconds, then scroll once per
  //  second, then hold at the end for two seconds)
  for(y=0; y<3; y++)
  {
    i = first - 2;
    if(i>count-3) i=count-3;
    if(i<0) i=0;
    i += y;

    if(table[i].dev[0] == 0) continue;
    sprintf(tmp, "%-6s %6s E    F", table[i].dev, table[i].cap);

    lcd.string(1, y+2, tmp);
    lcd.hbar(16, y+2, table[i].full);
  }


  #undef huge

/*    
// ** FILESYSTEMS *****
// /      543.2M E----F
// /dos/c   2.1G E----F
// /stuff   4.3G E----F
*/
  return HOLD_SCREEN;
#endif
  return 0;
}

