#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../shared/debug.h"

#include "screen.h"
#include "widget.h"


char *types[] = {"none",
		 "string",
		 "hbar",
		 "vbar",
		 "icon",
		 "title",
		 "scroller",
		 //"",
		 NULL,
                };
   


widget * widget_create()
{
   widget *w;

   debug("widget_create()\n");
   
   w = malloc(sizeof(widget));
   if(!w)
   {
      fprintf(stderr, "widget_create: Error allocating widget\n");
      return NULL;
   }

   w->id = NULL;
   w->type = 0;
   w->x = 1;
   w->y = 1;
   w->left = 1;
   w->top = 1;
   w->right = 0;
   w->bottom = 0;
   w->length = 1;
   w->speed = 1;
   w->text = NULL;

   return w;
}

int widget_destroy(widget *w)
{
   if(!w) return -1;

   debug("widget_destroy(%s)\n", w->id);
   
   if(w->id) free(w->id);
   //debug("widget_destroy: id...\n");
   if(w->text) free(w->text);
   //debug("widget_destroy: text...\n");

   free(w);
   //debug("widget_destroy: widget...\n");

   return 0;
}

widget * widget_find(screen *s, char *id)
{
   widget *w;

   if(!s) return NULL;
   if(!id) return NULL;

   debug("widget_find(%s)\n", id);
   
   LL_Rewind(s->widgets);
   do {
      w = LL_Get(s->widgets);
      if( (w)  &&  (0 == strcmp(w->id, id)))
      {
	 debug("widget_find:  Found %s\n", id);
	 return w;
      }
   } while(LL_Next(s->widgets) == 0);

   return NULL;
}

int widget_add(screen *s, char *id, char *type)
{
   int i;
   int valid=0;
   int wid_type=0;
   widget *w;

   debug("widget_add(%s, %s )\n", id, type);
   

   if(!s) return -1;
   if(!id) return -1;


   if(0 == strcmp(id, "heartbeat"))
   {
      s->heartbeat = 1;
      return 0;
   }
   
   // Make sure this screen doesn't already exist...
   w = widget_find(s, id);
   if(w)
   {
      return 1;
   }

   // Make sure it's a valid widget type
   for(i=1; types[i]; i++)
   {
      if(0 == strcmp(types[i], type))
      {
	 valid=1;
	 wid_type=i;
      }
   }
   if(!valid)
   {
      return 2;
   }
   

   debug("widget_add: making widget\n");
   

   // Now, make it...
   w = widget_create();
   if(!w)
   {
      fprintf(stderr, "widget_add:  Error creating widget\n");
      return -1;
   }

   w->id = strdup(id);
   if(!w->id)
   {
      fprintf(stderr, "widget_add:  Error allocating id\n");
      return -1;
   }

   w->type = wid_type;
   
   // TODO:  Check for errors here?
   LL_Push(s->widgets, (void *)w);
   

   return 0;
}

int widget_remove(screen *s, char *id)
{
   widget *w;

   debug("widget_remove(%s)\n", id);
   
   if(!s) return -1;
   if(!id) return -1;
   

   if(0 == strcmp(id, "heartbeat"))
   {
      s->heartbeat = 0;
      return 0;
   }
   
   // Make sure this screen *does* exist...
   w = widget_find(s, id);
   if(!w)
   {
      debug("widget_remove:  Error finding widget %s\n", id);
      return 1;
   }

   // TODO:  Check for errors here?
   LL_Remove(s->widgets, (void *)w);

   // ... and here?
   widget_destroy(w);

   return 0;
}

