/*

  This contains definitions for all the functions which clients can run.
  The functions here are to be called only from parse.c's interpreter.
  
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "../shared/debug.h"
#include "../shared/sockets.h"
#include "main.h"
#include "clients.h"
#include "parse.h"
#include "screen.h"
#include "widget.h"
#include "client_functions.h"


client_function commands[] = {
   {"test_func", test_func_func },
   {"hello", hello_func},
   {"client_set", client_set_func},
   {"client_add_key", client_add_key_func},
   {"client_del_key", client_del_key_func},
   {"screen_add", screen_add_func},
   {"screen_del", screen_del_func},
   {"screen_set", screen_set_func},
   {"widget_add", widget_add_func},
   {"widget_del", widget_del_func},
   {"widget_set", widget_set_func},
   {"menu_add", menu_add_func},
   {"menu_del", menu_del_func},
   {"menu_set", menu_set_func},
   // TODO:  Adhere these to the naming convention
   {"menu_item_add", menu_item_add_func},
   {"menu_item_del", menu_item_del_func},
   {"menu_item_set", menu_item_set_func},
   {NULL, NULL },
};


// TODO:  Maybe more error-checking for "->"'s?


///////////////////////////////////////////////////////////////////////////
//
//
int test_func_func(client *c, int argc, char **argv)
{
   int i;
   char str[256];
   
   for(i=0; i<argc; i++)
   {
      sprintf(str, "test_func_func:  %i -> %s\n", i, argv[i]);
      printf(str);
      sock_send_string(c->sock, str);
   }
   return 0;
}


///////////////////////////////////////////////////////////////////////////
//
//
int hello_func(client *c, int argc, char **argv)
{
   char str[256];

   // TODO:  Give *real* info about the server/lcd...
   
   debug("Hello!\n");

   sprintf(str,
	   "connect LCDproc %s lcd wid 20 hgt 4 cellwid 5 cellhgt 8\n",
	   version);
   sock_send_string(c->sock, str);

   if(c->data)
      c->data->ack = 1;
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int client_set_func(client *c, int argc, char **argv)
{
   int i;

   if(!c->data->ack) return 1;
   
   for(i=1; i<argc; i++)
   {
      // Handle the "name" parameter
      if(0 == strcmp(argv[i], "name"))
      {
	 if(argc > i+1)
	 {
	    i++;
	    debug("client_set: name=\"%s\"\n", argv[i]);

	    // set the name...
	    if(c->data->name)
	       free(c->data->name);
	    c->data->name = strdup(argv[i]);
	 }
	 else
	 {
	    sock_send_string(c->sock, "huh? name requires a parameter\n");
	 }
      }
      else
      {
	 sock_send_string(c->sock, "huh? invalid parameter\n");
      }
   }

   // If there were no parameters...
   if(argc == 1)
      sock_send_string(c->sock, "huh? What do you want to set?\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int client_add_key_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;

   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int client_del_key_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int screen_add_func(client *c, int argc, char **argv)
{
   int err=0;
   
   if(!c->data->ack) return 1;
   
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh?  Specify a screen #id\n");
      return 0;
   }
   if(argc > 2)
   {
      sock_send_string(c->sock, "huh?  Too many parameters...\n");
      return 0;
   }


   debug("screen_add: Adding screen %s\n", argv[1]);
   err = screen_add(c, argv[1]);
   if(err < 0)
      fprintf(stderr, "screen_add_func:  Error adding screen\n");
   if(err > 0)
      sock_send_string(c->sock,
		       "huh? You already have a screen with that id#\n");
   
   //sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int screen_del_func(client *c, int argc, char **argv)
{
   int err=0;
   
   if(!c->data->ack) return 1;
   
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh?  Specify a screen #id\n");
      return 0;
   }
   if(argc > 2)
   {
      sock_send_string(c->sock, "huh?  Too many parameters...\n");
      return 0;
   }


   debug("screen_del: Deleting screen %s\n", argv[1]);
   err = screen_remove(c, argv[1]);
   if(err < 0)
      fprintf(stderr, "screen_del_func:  Error removing screen\n");
   if(err > 0)
      sock_send_string(c->sock,
		       "huh? You don't have a screen with that id#\n");
   
   //sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int screen_set_func(client *c, int argc, char **argv)
{
   int i;

   int number;
   char *id;
   screen *s;
   
   if(!c->data->ack) return 1;

   
   // If there weren't enough parameters...
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh? You must specify a screen id\n");
      return 0;
   }
   
   if(argc == 2)
   {
      sock_send_string(c->sock, "huh? What do you want to set?\n");
      return 0;
   }
   

   id = argv[1];
   s = screen_find(c, id);
   if(!s)
   {
      sock_send_string(c->sock, "huh? Invalid screen id\n");
      return 0;
   }
   
   // Handle the rest of the parameters
   for(i=2; i<argc; i++)
   {
      // Handle the "name" parameter
      if(0 == strcmp(argv[i], "name"))
      {
	 if(argc > i+1)
	 {
	    i++;
	    debug("screen_set: name=\"%s\"\n", argv[i]);

	    // set the name...
	    if(s->name)
	       free(s->name);
	    s->name = strdup(argv[i]);
	 }
	 else
	 {
	    sock_send_string(c->sock, "huh? name requires a parameter\n");
	 }
      }
      // Handle the "priority" parameter
      else if(0 == strcmp(argv[i], "priority"))
      {
	 if(argc > i+1)
	 {
	    i++;
	    debug("screen_set: priority=\"%s\"\n", argv[i]);

	    // set the priority...
	    number = atoi(argv[i]);
	    if(number > 0)
	       s->priority = number;
	 }
	 else
	 {
	    sock_send_string(c->sock, "huh? priority requires a parameter\n");
	 }
      }
      // Handle the "duration" parameter
      else if(0 == strcmp(argv[i], "duration"))
      {
	 if(argc > i+1)
	 {
	    i++;
	    debug("screen_set: duration=\"%s\"\n", argv[i]);

	    // set the duration...
	    number = atoi(argv[i]);
	    if(number > 0)
	       s->duration = number;
	 }
	 else
	 {
	    sock_send_string(c->sock, "huh? duration requires a parameter\n");
	 }
      }
      else
      {
	 sock_send_string(c->sock, "huh? invalid parameter\n");
      }
   } // done checking argv

   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int widget_add_func(client *c, int argc, char **argv)
{
   int err;

   char *type;
   char *sid;
   char *wid;
   screen *s;

   
   if(!c->data->ack) return 1;

   
   // If there weren't enough parameters...
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh? You must specify a screen id\n");
      return 0;
   }
   if(argc < 3)
   {
      sock_send_string(c->sock, "huh? You must specify a widget id\n");
      return 0;
   }
   if(argc < 4)
   {
      sock_send_string(c->sock, "huh? You must specify a widget type\n");
      return 0;
   }
   if(argc > 4)
   {
      sock_send_string(c->sock, "huh? Too many parameters\n");
      return 0;
   }
   

   sid = argv[1];
   wid = argv[2];

   s = screen_find(c, sid);
   if(!s)
   {
      sock_send_string(c->sock, "huh? Invalid screen id\n");
      return 0;
   }

   // Add the widget and set its type...
   type = argv[3];

   err = widget_add(s, wid, type);
   if(err<0)
      fprintf(stderr, "widget_add_func:  Error adding widget\n");
   if(err == 1) // already exists
      sock_send_string(c->sock,
		       "huh? You already have a widget with that id#\n");
   if(err == 2) // invalid widget type
      sock_send_string(c->sock, "huh? Invalid widget type\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int widget_del_func(client *c, int argc, char **argv)
{
   int err=0;

   char *sid;
   char *wid;
   screen *s;
   
   if(!c->data->ack) return 1;
   
   // Check the number of parameters...
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh?  Specify a screen #id\n");
      return 0;
   }
   if(argc < 3)
   {
      sock_send_string(c->sock, "huh?  Specify a widget #id\n");
      return 0;
   }
   if(argc > 3)
   {
      sock_send_string(c->sock, "huh?  Too many parameters...\n");
      return 0;
   }


   sid = argv[1];
   wid = argv[2];
   
   debug("screen_del: Deleting widget %s.%s\n", sid, wid);

   s = screen_find(c, sid);
   if(!s)
   {
      sock_send_string(c->sock, "huh? Invalid screen id\n");
   }
   
   err = widget_remove(s, wid);
   if(err < 0)
      fprintf(stderr, "widget_del_func:  Error removing widget\n");
   if(err > 0)
      sock_send_string(c->sock,
		       "huh? You don't have a widget with that id#\n");
   
   //sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
// Ack!  This is long!
int widget_set_func(client *c, int argc, char **argv)
{
   int i;

   int x, y;
   int left, top, right, bottom;
   int length, direction;
   int speed;
   char *sid, *wid;
   screen *s;
   widget *w;
   
   if(!c->data->ack) return 1;

   
   // If there weren't enough parameters...
   if(argc < 2)
   {
      sock_send_string(c->sock, "huh? You must specify a screen id\n");
      return 0;
   }
   if(argc < 3)
   {
      sock_send_string(c->sock, "huh? You must specify a widget id\n");
      return 0;
   }
   if(argc < 4)
   {
      sock_send_string(c->sock, "huh? You must send some widget data\n");
      return 0;
   }
   
   
   sid = argv[1];
   wid = argv[2];
   s = screen_find(c, sid);
   if(!s)
   {
      sock_send_string(c->sock, "huh? Invalid screen id\n");
      return 0;
   }
   w = widget_find(s, wid);
   if(!w)
   {
      sock_send_string(c->sock, "huh? Invalid widget id\n");
      return 0;
   }


   // FIXME?  Shouldn't this be handled in widget.c?
   i = 3;
   switch(w->type)
   {
      case WID_STRING:  // String takes "x y text"
	 if(argc != i+3)
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 else
	 {
	    if((!isdigit(argv[i][0]))  ||  (!isdigit(argv[i+1][0])))
	    {
	       sock_send_string(c->sock, "huh? Invalid coordinates\n");
	    }
	    else  // Set all the data...
	    {
	       x = atoi(argv[i]);
	       y = atoi(argv[i+1]);
	       w->x = x;
	       w->y = y;
	       if(w->text)
		  free(w->text);
	       w->text = strdup(argv[i+2]);
	       if(!w->text)
	       {
		  fprintf(stderr,
			  "widget_set_func: Error allocating string\n");
		  return -1;
	       }
	       debug("Widget %s set to %s\n", wid, w->text);
	    }
	 }
	 break;
      case WID_HBAR:  // Hbar takes "x y length"
	 if(argc != i+3)
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 else
	 {
	    if((!isdigit(argv[i][0]))  ||  (!isdigit(argv[i+1][0])))
	    {
	       sock_send_string(c->sock, "huh? Invalid coordinates\n");
	    }
	    else
	    {
	       x = atoi(argv[i]);
	       y = atoi(argv[i+1]);
	       length = atoi(argv[i+2]);
	       w->x = x;
	       w->y = y;
	       w->length = length;
	    }
	    debug("Widget %s set to %i\n", wid, w->length);
	 }
	 break;
      case WID_VBAR:  // Vbar takes "x y length"
	 if(argc != i+3)
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 else
	 {
	    if((!isdigit(argv[i][0]))  ||  (!isdigit(argv[i+1][0])))
	    {
	       sock_send_string(c->sock, "huh? Invalid coordinates\n");
	    }
	    else
	    {
	       x = atoi(argv[i]);
	       y = atoi(argv[i+1]);
	       length = atoi(argv[i+2]);
	       w->x = x;
	       w->y = y;
	       w->length = length;
	    }
	    debug("Widget %s set to %i\n", wid, w->length);
	 }
	 break;
      case WID_ICON:  // Icon takes "x y binary_data"
	 if(argc != i+3)
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 else
	 {
	    if((!isdigit(argv[i][0]))  ||  (!isdigit(argv[i+1][0])))
	    {
	       sock_send_string(c->sock, "huh? Invalid coordinates\n");
	    }
	    else
	    {
	       x = atoi(argv[i]);
	       y = atoi(argv[i+1]);
	       w->x = x;
	       w->y = y;
	       // TODO:  Parse binary data and copy it to widget's data...
	    }
	 }
	 sock_send_string(c->sock, "huh? Widget type not yet implemented\n");
	 break;
      case WID_TITLE:  // title takes "text"
	 if(argc != i+1)
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 else
	 {
	    if(w->text)
	       free(w->text);
	    w->text = strdup(argv[i]);
	    if(!w->text)
	    {
	       fprintf(stderr,
		       "widget_set_func: Error allocating string\n");
	       return -1;
	    }
	    debug("Widget %s set to %s\n", wid, w->text);
	 }
	 break;
      case WID_SCROLLER:  // Scroller takes "left top right bottom direction speed text"
	  if(argc != i+7) {
	      //printf("d'oh! wrong number of args...\n");
	    sock_send_string(c->sock, "huh? Wrong number of arguments\n");
	 } else
	 {
	    if((!isdigit(argv[i][0]))  ||  (!isdigit(argv[i+1][0])) || (!isdigit(argv[i+2][0])) || (!isdigit(argv[i+3][0])))
	    {
	       sock_send_string(c->sock, "huh? Invalid coordinates\n");
	    }
	    else
	    {
	       left = atoi(argv[i]);
	       //printf("left: %d\n",left);
	       top = atoi(argv[i+1]);
	       //printf("top: %d\n",top);
	       right = atoi(argv[i+2]);
	       //printf("right: %d\n",right);
	       bottom = atoi(argv[i+3]);
	       //printf("bottom: %d\n",bottom);
	       direction = (int)(argv[i+4][0]);
	       //printf("dir: %c\n",(char)direction);
	       speed = atoi(argv[i+5]);
	       //printf("speed: %d\n",speed);
	       // Direction must be v or h
	       if(((char)direction != 'h')  &&  ((char)direction != 'v'))
	       {
		  sock_send_string(c->sock, "huh? Invalid direction\n");
	       }
	       else
	       {
		  w->left = left;
		  w->top = top;
		  w->right = right;
		  w->bottom = bottom;
		  w->length = direction;
		  w->speed = speed;
		  if(w->text)
		     free(w->text);
		  w->text = strdup(argv[i+6]);
		  if(!w->text)
		  {
		     fprintf(stderr, "widget_set_func: Error allocating string\n");
		     return -1;
		  }
		  debug("Widget %s set to %s\n", wid, w->text);
	       }
	    }
	 }
	 //sock_send_string(c->sock, "huh? Widget type not yet implemented\n");
	 break;
      case WID_NONE:
      default:
	 sock_send_string(c->sock, "huh? Widget has no type\n");
	 break;
   }

   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_add_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_del_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_set_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_item_add_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_item_del_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
//
//
int menu_item_set_func(client *c, int argc, char **argv)
{
   
   
   if(!c->data->ack) return 1;
   
   sock_send_string(c->sock, "huh?  Not implemented yet.\n");
   
   return 0;
}

///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////

