#include <string.h>

#include "../shared/LL.h"

#include "drivers/lcd.h"

#include "screen.h"
#include "screenlist.h"
#include "widget.h"
#include "render.h"



int heartbeat=HEART_OPEN;


int draw_screen(screen *s, int timer)
{
   char str[256];
   widget *w;
   static screen *old_s=NULL;
   
   int x, y;
   int length, speed;

   int reset = 1;
   
   if(!s) return -1;

   if(s == old_s) reset = 0;
   old_s = s;
   

   lcd.clear();
   
   
   LL_Rewind(s->widgets);
   do {
      w = (widget *)LL_Get(s->widgets);
      if(!w) return -1;

      switch(w->type)
      {
	 case WID_STRING:
	    if((w->x > 0) && (w->y > 0) && (w->text))
	    {
	       lcd.string(w->x, w->y, w->text);
	    }
	    break;
	 case WID_HBAR:
	    if(reset)
	    {
	       lcd.init_hbar();
	       reset = 0;
	    }
	    if((w->x > 0) && (w->y > 0))
	    {
	       if(w->length > 0)
	       {
		  lcd.hbar(w->x, w->y, w->length);
	       }
	       else if(w->length < 0)
	       {
		  // TODO:  Rearrange stuff to get left-extending
		  // hbars to draw correctly...
		  // .. er, this'll require driver modifications,
		  // so I'll leave it out for now.
	       }
	    }
	    break;
	 case WID_VBAR:
	    if(reset)
	    {
	       lcd.init_vbar();
	       reset = 0;
	    }
	    if((w->x > 0) && (w->y > 0))
	    {
	       if(w->length > 0)
	       {
		  lcd.vbar(w->x, w->length);
	       }
	       else if(w->length < 0)
	       {
		  // TODO:  Rearrange stuff to get down-extending
		  // vbars to draw correctly...
		  // .. er, this'll require driver modifications,
		  // so I'll leave it out for now.
	       }
	    }
	    break;
	 case WID_ICON:
	    break;
	 case WID_TITLE:
	    if(!w->text) break;
	    
	    memset(str, 255, 255);
	    str[256] = 0;
	    str[2] = ' ';
	    length = strlen(w->text);
	    if(length <= 14)
	    {
	       memcpy(str+3, w->text, length);
	       str[length+3] = ' ';
	    }
	    else // Scroll the title, if it doesn't fit...
	    {
	       speed = 1;
	       x = timer / speed;
	       y = x / length;

	       // Make sure the whole title gets displayed, at least...
	       if(!screenlist_action) screenlist_action = RENDER_HOLD;
	       if(x > length - 6)
	       {
		  // Release hold after it has been displayed
		  if(!screenlist_action  ||  screenlist_action == RENDER_HOLD)
		     screenlist_action = 0;
	       }
	       x %= (length);
	       x -= 3;
	       if(x < 0) x = 0;
	       if(x > length - 14) x = length - 14;
	       
	       if(y&1) // Scrolling backwards...
	       {
		  x = (length-14) - x;
	       }
	       strncpy(str+3, w->text+x, 14);
	       str[lcd.wid-3] = ' ';
	    }
	    str[lcd.wid] = 0;
	    
	    lcd.string(1,1,str);
	    break;
	 case WID_SCROLLER:
	    break;
	 case WID_NONE:
	 default:
	    break;
      }
   } while(LL_Next(s->widgets) == 0);

   
   
   if(heartbeat)
   {
      if(s->heartbeat  ||  heartbeat == HEART_ON)
      {
	 // Set this to pulsate like a real heart beat...
	 // (binary is fun...  :)
	 lcd.icon(!((timer+4)&5), 0);
	 lcd.chr(lcd.wid, 1, 0);
      }
   }
   
   lcd.flush();
   
   return 0;
}

