#include "lcd.h"
#include "menu.h"

// FIXME: Implement this where it is supposed to be...
#include <time.h>
void framedelay()
{
  usleep(125000);
}
void heartbeat()
{
}
extern int PAD;



typedef struct menu_info 
{
  int selected;
  int length;
} menu_info;



static int draw_menu(Menu menu, menu_info *info);
static int fill_menu_info(Menu menu, menu_info *info);
static int menu_handle_action(menu_item *item);


int do_menu(Menu menu)
{
  menu_info info;
  int key=0;
  int status=MENU_OK;
  int done=0;

  int (*func)();
  int (*readfunc)(int);
  

  if(!menu) return MENU_ERROR;

  fill_menu_info(menu, &info);


  while(!done)
  {
      
    draw_menu(menu, &info);

    // FIXME: This should use a better keypress interface, which
    // FIXME: handles things according to keybindings...

    for(key = lcd.getkey(); key==0; key = lcd.getkey())
    {
      // sleep for 1/8th second...
      framedelay();
      // do the heartbeat...
      heartbeat();
      // Check for client input...
    }

    
    // Handle the key according to the keybindings...
    switch(key)
    {
      case 'A': done=1; break;
      case 'B': if(info.selected > 0) info.selected--; break;
      case 'C': if(menu[info.selected+1].text) info.selected++; break;
      case 'D':
	switch(menu[info.selected].type)
	{
	  case TYPE_MENU: status = do_menu(menu[info.selected].data);
	    break;
	  case TYPE_FUNC:
	    func = menu[info.selected].data;
	    if(func)
	      status = func();
	    break;
	  case TYPE_CHEK:
	    readfunc = menu[info.selected].data;
	    if(readfunc)
	      status = readfunc(MENU_CHECK);
	    status &= 0xffff0000;
	    break;
	  default:
	    break;
	}
	
	switch(status)
	{
	  case MENU_OK:
	    break;
	  case MENU_CLOSE:
	    return MENU_OK;
	  case MENU_QUIT:
	    return MENU_QUIT;
//	  case MENU_KILL:
//	    return MENU_KILL;
	  case MENU_ERROR:
	    return MENU_ERROR;
	}
	
	// status = menu_handle_action(&menu[info.selected]);
	// TODO: It should now do special stuff for "mover" widgets,
	// TODO: and handle the return code appropriately.
	break;
      default: break;
    }
    
  }
  
  return status;
  
}

static int draw_menu(Menu menu, menu_info *info)
{
  int i;
  int x=1, y=1;
  int top=0, bottom=0;

  int (*readfunc)(int);
  
  // these should maybe be removed:
  int wid=20, hgt=4;
  

  if(!menu) return MENU_ERROR;

  lcd.clear();

  
  // Scroll down until the selected item is centered, if possible...
  top = info->selected - (hgt/2);
  if(top<0) top=0;  
  bottom = top+hgt;
  if(bottom > info->length) bottom=info->length;
  top = bottom-hgt;
  if(top<0) top=0;  
  
  

  // Draw all visible items...
  for(i=top; i<bottom; i++, y++)
  {
    if(i == info->selected) lcd.chr(2,y,'>');
    
    switch(menu[i].type)
    {
      case TYPE_TITL:
	lcd.chr(1,y,PAD);
	lcd.chr(2,y,PAD);
        lcd.string(4,y,menu[i].text);
	for(x=strlen(menu[i].text)+5; x <= wid; x++)
	  lcd.chr(x,y,PAD);
        break;
      case TYPE_MENU:
	lcd.string(3,y,menu[i].text);
	lcd.chr(wid,y,'>');
        break;
      case TYPE_FUNC:
	lcd.string(3,y,menu[i].text);
        break;
      case TYPE_CHEK:
	if(menu[i].data)
	{
	  readfunc = menu[i].data;
	  if(readfunc(MENU_READ))
	    lcd.chr(wid,y,'*');
	  else
	    lcd.chr(wid,y,'O');
	}
	lcd.string(3,y,menu[i].text);
        break;
      case TYPE_SLID:
	lcd.string(3,y,menu[i].text);
        break;
      case TYPE_MOVE:
        break;
      default:
        break;
    }
  }

  if(top != 0)
    lcd.chr(1,1,'^');
  if(bottom < info->length)
    lcd.chr(1,hgt,'v');
  
  
  lcd.flush();

  return 0;
}


static int fill_menu_info(Menu menu, menu_info *info)
{
  int i;

  info->selected = 0;
  
  // count the entries in the menu
  for(i=0; menu[i].text; i++);
  
  info->length = i;
  
  return 0;
  
}

static int menu_handle_action(menu_item *item)
{
  return MENU_OK;
}
