#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>

// For debugging purposes...
// ... should not be defined in a release.
// (defaults to 13666)
//#define LCDPORT 13667

#include "../shared/debug.h"

#include "drivers/lcd.h"
#include "sock.h"
#include "clients.h"
#include "screenlist.h"
#include "screen.h"
#include "parse.h"
#include "render.h"
#include "serverscreens.h"
#include "input.h"


char *version = VERSION;
char *build_date = __DATE__;

// 1/8th second is a single time unit...
#define TIME_UNIT 125000


void exit_program(int val);
void HelpScreen();


int main(int argc, char **argv)
{
   // TODO:  Use a config file!
   //char cfgfile[256] = "/etc/LCDd.cf";
   int i;
   int child;
   screen *s;
   char *str, *ing;
   

   
   // Ctrl-C will cause a clean exit...
   signal(SIGINT, exit_program);
   // and "kill"...
   signal(SIGTERM, exit_program);
   // and "kill -HUP" (hangup)...
   signal(SIGHUP, exit_program);
   // and just in case, "kill -KILL" (which cannot be trapped; but oh well)
   signal(SIGKILL, exit_program);


   lcd_init("");

   
   // Parse the command line now...
   // TODO:  Move this to a separate function?
   for(i=1; i<argc; i++)
   {
      if(argv[i][0] == '-') switch(argv[i][1])
      {
	 // D for Driver...
	 case 'D': 
	 case 'd':
	    if(argc < i+1) HelpScreen();
	    str = argv[i+1];
	    ing = NULL;
	    if(argc > i+2)
	    {
	       if(argv[i+2][0] != '-')
	       {
		  ing = argv[i+2];
	       }
	    }
	    lcd_add_driver(str, ing);
	    break;
      
	    // otherwise...  Get help!
	 default: HelpScreen(); break;
      }
   }

   

   // Now init a bunch of required stuff...

   if(sock_create_server() <= 0)
   {
      printf("Error opening socket.\n");
      return 1;
   }

   if(client_init() < 0)
   {
      printf("Error initializing client list\n");
      return 1;
   }
   
   if(screenlist_init() < 0)
   {
      printf("Error initializing screen list\n");
      return 1;
   }

   // Make sure the server screen shows up every once in a while..
   if(server_screen_init() < 0)
   {
      printf("Error initializing server screens\n");
      return 1;
   }



   
   // Now, go into daemon mode...
   if ((child = fork()) != 0) exit(0);             /* PARENT EXITS */
   //setsid();                                       /* RELEASE TTY */



   
   // Main loop...
   while(1)
   {
      sock_poll_clients();
      parse_all_client_messages();
      handle_input();

      // Timer gets reset by screenlist_next()
      timer++;
      if(timer >= 32)
      {
	 s = screenlist_next();
	 //if(s) debug("Screen: %s\n", s->id);
      }
      // Just in case it gets out of hand...
      if(timer >= 4096) timer = 0;
      update_server_screen(timer);
      s = screenlist_current();

      // render something here...
      if(s) draw_screen(s, timer);
      else  no_screen_screen(timer);
      
      usleep(TIME_UNIT);
   }


   // Quit!
   exit_program(0);
   
   return 0;
}


void exit_program(int val)
{
   // Say goodbye!
   goodbye_screen();
   
   // Can go anywhere...
   lcd_shutdown();
   // Must come before screenlist_shutdown
   client_shutdown();
   // Must come after client_shutdown
   screenlist_shutdown();
   // Should come after client_shutdown
   sock_close_all();
   
   exit(0);

}


void HelpScreen()
{
  printf("LCDproc server daemon, %s\n", version);
  printf("Usage: lcdproc [-d driver [args]]\n");
  printf("\tOptions in []'s are optional.\n");
  printf("\t-d driver is the output driver to use:\n");
  printf("\t\tMtxOrb, curses, text, HD44780, joy\n");
  printf("\targs will be passed to the driver for init\n");
  printf("\n");
  printf("\tUse \"man LCDd\" for more info.\n");
  printf("Example:\n");
  printf("\tLCDd -d MtxOrb \"dev /dev/lcd\" -d joy\n");
  printf("\n");
  exit(0);
}

