#include <stdlib.h>
#include <stdio.h>

#include "../shared/LL.h"
#include "../shared/sockets.h"
#include "../shared/debug.h"
#include "screenlist.h"
#include "screen.h"
#include "clients.h"



int screenlist_action=0;

int timer=0;

LL * screenlist;


int screenlist_add_end(screen *screen);
screen * screenlist_next_roll();
screen * screenlist_prev_roll();


int screenlist_init()
{
   debug("screenlist_init()\n");
   
   screenlist = LL_new();
   if(!screenlist)
   {
      fprintf(stderr, "screenlist_init: Error allocating list\n");
      return -1;
   }

   screenlist_action = 0;
   timer = 0;
   
   return 0;
}

int screenlist_shutdown()
{
   debug("screenlist_shutdown()\n");
   
   LL_Destroy(screenlist);
   
   return 0;
}

int screenlist_remove(screen *s)
{
   debug("screenlist_remove()\n");
   
   if(!LL_Remove(screenlist, s))
      return -1;
   else return 0;
}

int screenlist_remove_all(screen *s)
{
   int i=0;
   
   debug("screenlist_remove_all()\n");
   
   while(LL_Remove(screenlist, s))
      i++;

   return i;
}

LL * screenlist_getlist()
{
   debug("screenlist_getlist()\n");
   
   return screenlist;
}

screen * screenlist_current()
{
   screen *s;
   
   s = (screen *)LL_GetFirst(screenlist);

   return s;
}

int screenlist_add(screen *s)
{
   // TODO:  Different queueing modes...
   return screenlist_add_end(s);
}

screen * screenlist_next()
{
   char str[256];
   client *c;
   screen *s;

   s = screenlist_current();

   // If we're on hold, don't advance!
   if(screenlist_action == SCR_HOLD) return s;

   // Otherwise, reset it no regular operation
   screenlist_action = 0;
   
   // Tell the client we're done with the current screen
   if(s)
   {
      c = s->parent;
      if(c)  // Tell the client we're not listening any more...
      {
	 sprintf(str, "ignore %s\n", s->id);
	 sock_send_string(c->sock, str);
      }
      else  // The server has the display, so do nothing
      {
      }
   }


   // Call the selected queuing function...
   // TODO:  Different queueing modes...
   s = screenlist_next_roll();

   if(s)
   {
      c = s->parent;
      if(c)  // Tell the client we're paying attention...
      {
	 sprintf(str, "listen %s\n", s->id);
	 sock_send_string(c->sock, str);
      }
      else  // The server has the display, so do nothing
      {
      }
   }

   timer = 0;
   
   return s;
}

screen * screenlist_prev()
{
   char str[256];
   client *c;
   screen *s;

   s = screenlist_current();

   // If we're on hold, don't advance!
   if(screenlist_action == SCR_HOLD) return s;
   
   // Otherwise, reset it no regular operation
   screenlist_action = 0;
   
   // Tell the client we're done with the current screen
   if(s)
   {
      c = s->parent;
      if(c)  // Tell the client we're not listening any more...
      {
	 sprintf(str, "ignore %s\n", s->id);
	 sock_send_string(c->sock, str);
      }
      else  // The server has the display, so do nothing
      {
      }
   }


   // Call the selected queuing function...
   // TODO:  Different queueing modes...
   s = screenlist_prev_roll();

   if(s)
   {
      c = s->parent;
      if(c)  // Tell the client we're paying attention...
      {
	 sprintf(str, "listen %s\n", s->id);
	 sock_send_string(c->sock, str);
      }
      else  // The server has the display, so do nothing
      {
      }
   }

   timer = 0;
   
   return s;
}


// Adds new screens to the end of the screenlist...
int screenlist_add_end(screen *screen)
{
   debug("screenlist_add_end()\n");
   
   return LL_Push(screenlist, (void *)screen);
}

// Simple round-robin approach to screen cycling...
screen * screenlist_next_roll()
{
   //debug("screenlist_next_roll()\n");
   
   if(LL_UnRoll(screenlist) != 0) return NULL;

   return screenlist_current();
}

// Simple round-robin approach to screen cycling...
screen * screenlist_prev_roll()
{
   //debug("screenlist_prev_roll()\n");
   
   if(LL_Roll(screenlist) != 0) return NULL;

   return screenlist_current();
}
