#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#include "../../shared/sockets.h"

#include "main.h"
#include "mode.h"
#include "mem.h"

struct meminfo { int total, cache, buffers, free, shared; };

int meminfo_fd = 0;

static void get_mem_info(struct meminfo *result);


static void get_mem_info(struct meminfo *result) 
{
//  int i, res; char *bufptr;

  reread(meminfo_fd, "get_meminfo:");
  result[0].total   = getentry("MemTotal:", buffer);
  result[0].free    = getentry("MemFree:", buffer);
  result[0].shared  = getentry("MemShared:", buffer);
  result[0].buffers = getentry("Buffers:", buffer);
  result[0].cache   = getentry("Cached:", buffer);
  result[1].total   = getentry("SwapTotal:", buffer);
  result[1].free    = getentry("SwapFree:", buffer); 
}


int mem_init()
{
   if(!meminfo_fd)
   {
      meminfo_fd = open("/proc/meminfo",O_RDONLY);

      sock_send_string(sock, "screen_add M\n");
      sock_send_string(sock, "screen_set M name {Memory & Swap Use}\n");
      sock_send_string(sock, "widget_add M title title\n");
      sock_send_string(sock, "widget_set M title { MEM -==- SWAP}\n");
      sock_send_string(sock, "widget_add M totl string\n");
      sock_send_string(sock, "widget_add M used string\n");
      sock_send_string(sock, "widget_set M totl 9 2 Totl\n");
      sock_send_string(sock, "widget_set M used 9 3 Free\n");
      sock_send_string(sock, "widget_add M EF string\n");
      sock_send_string(sock, "widget_set M EF 1 4 {E       F  E       F}\n");
      sock_send_string(sock, "widget_add M memtotl string\n");
      sock_send_string(sock, "widget_add M memused string\n");
      sock_send_string(sock, "widget_add M swaptotl string\n");
      sock_send_string(sock, "widget_add M swapused string\n");
      sock_send_string(sock, "widget_add M memgauge hbar\n");
      sock_send_string(sock, "widget_add M swapgauge hbar\n");
      sock_send_string(sock, "widget_set M memgauge 2 4 0\n");
      sock_send_string(sock, "widget_set M swapgauge 13 4 0\n");
      //sock_send_string(sock, "\n");
   }

   return 0;
}

int mem_close()
{
   if(meminfo_fd)
      meminfo_fd = open("/proc/meminfo",O_RDONLY);

   meminfo_fd = 0;
   
   return 0;
}


/////////////////////////////////////////////////////////////////////////
// Mem Screen displays info about memory and swap usage...
//
int mem_screen(int rep, int display)
{
  int n;
  struct meminfo mem[2];



  // Total memory
  get_mem_info(mem);
  sprintf(tmp, "widget_set M memtotl 1 2 {%6dk}\n", mem[0].total);
  if(display) sock_send_string(sock, tmp);

  // Free memory (plus buffers and cache)
  sprintf(tmp, "widget_set M memused 1 3 {%6dk}\n",
	  mem[0].free + mem[0].buffers + mem[0].cache);
  if(display) sock_send_string(sock, tmp);

  // Total swap
  sprintf(tmp, "widget_set M swaptotl 14 2 {%6dk}\n", mem[1].total);
  if(display) sock_send_string(sock, tmp);

  // Free swap
  sprintf(tmp, "widget_set M swapused 14 3 {%6dk}", mem[1].free);
  if(display) sock_send_string(sock, tmp);


  // Free memory graph
  n = (int)(35.0 -
              ((float)mem[0].free + (float)mem[0].buffers + (float)mem[0].cache)
	    / (float)mem[0].total
            * 35.0);
  sprintf(tmp, "widget_set M memgauge 2 4 %i\n", n);
  if(display) sock_send_string(sock, tmp);

  // Free swap graph
  n = (int)(35.0 -
              (float)mem[1].free / (float)mem[1].total
            * 35.0);
  sprintf(tmp, "widget_set M swapgauge 13 4 %i\n", n);
  if(display) sock_send_string(sock, tmp);


  return 0;
} // End mem_screen()

