#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>

#include "../../shared/sockets.h"
#include "../../shared/debug.h"

#include "main.h"
#include "mode.h"
#include "cpu.h"

struct load { unsigned long total, user, system, nice, idle; };

int load_fd = 0;
static void get_load(struct load * result);


static void get_load(struct load * result) 
{
  static struct load last_load = { 0, 0, 0, 0, 0 }; struct load curr_load;

  reread(load_fd, "get_load:");
  sscanf(buffer, "%*s %lu %lu %lu %lu\n",
	 &curr_load.user,
	 &curr_load.nice,
	 &curr_load.system,
	 &curr_load.idle);
  curr_load.total = curr_load.user
     + curr_load.nice
     + curr_load.system
     + curr_load.idle;
  result->total  = curr_load.total  - last_load.total;
  result->user   = curr_load.user   - last_load.user;
  result->nice   = curr_load.nice   - last_load.nice;
  result->system = curr_load.system - last_load.system;
  result->idle   = curr_load.idle   - last_load.idle;
  last_load.total  = curr_load.total;
  last_load.user   = curr_load.user;
  last_load.nice   = curr_load.nice;
  last_load.system = curr_load.system;
  last_load.idle   = curr_load.idle; 
}



int cpu_init()
{
   if(!load_fd)
   {
      load_fd = open("/proc/stat",O_RDONLY);
   }

   return 0;
}

int cpu_close()
{
   if(load_fd)
      close(load_fd);

   load_fd = 0;
   
   return 0;
}


//////////////////////////////////////////////////////////////////////////
// CPU screen shows info about percentage of the CPU being used
//
int cpu_screen(int rep, int display)
{
#undef CPU_BUF_SIZE
#define CPU_BUF_SIZE 4
   int i, j, n;
   static int first = 1;
   float value;
   static float cpu[CPU_BUF_SIZE + 1][5];// last buffer is scratch
   struct load load;


   if(first)
   {
      first = 0;

      sock_send_string(sock, "screen_add C\n");
      sock_send_string(sock, "screen_set C name {CPU Use}\n");
      sock_send_string(sock, "widget_add C title title\n");
      sock_send_string(sock, "widget_set C title {CPU LOAD}\n");
      sock_send_string(sock, "widget_add C one string\n");
      sock_send_string(sock, "widget_add C two string\n");
      sock_send_string(sock, "widget_add C three string\n");
      sock_send_string(sock,
		       "widget_set C one 1 2 {Usr  0.0% Nice  0.0%}\n");
      sock_send_string(sock,
		       "widget_set C two 1 3 {Sys  0.0% Idle  0.0%}\n");
      sock_send_string(sock,
		       "widget_set C three 1 4 {0%              100%}\n");
      sock_send_string(sock, "widget_add C usr string\n");
      sock_send_string(sock, "widget_add C nice string\n");
      sock_send_string(sock, "widget_add C sys string\n");
      sock_send_string(sock, "widget_add C idle string\n");
      sock_send_string(sock, "widget_add C bar hbar\n");
      sock_send_string(sock, "widget_set C bar 3 4 0\n");

      return 0;
   }
   //else return 0;
  
   get_load(&load);

   // Shift values over by one
   for(i=0; i<(CPU_BUF_SIZE-1); i++)
      for(j=0; j<5; j++)
	 cpu[i][j] = cpu[i+1][j];
   
   // Read new data
   cpu[CPU_BUF_SIZE-1][0] = ((float)load.user / (float)load.total) * 100.0;
   cpu[CPU_BUF_SIZE-1][1] = ((float)load.system / (float)load.total) * 100.0;
   cpu[CPU_BUF_SIZE-1][2] = ((float)load.nice / (float)load.total) * 100.0;
   cpu[CPU_BUF_SIZE-1][3] = ((float)load.idle / (float)load.total) * 100.0;
   cpu[CPU_BUF_SIZE-1][4] = (((float)load.user + (float)load.system +
			      (float)load.nice) / (float)load.total) * 100.0;

   // Only clear on first display...
   if(!rep)
   {
      /*
      // Make all the same, if this is the first time...
      for(i=0; i<CPU_BUF_SIZE-1; i++)
         for(j=0; j<5; j++)
            cpu[i][j] = cpu[CPU_BUF_SIZE-1][j];
      */
   }
   


   // Average values for final result
   for(i=0; i<5; i++)
   {
      value = 0;
      for(j=0; j<CPU_BUF_SIZE; j++)
      {
	 value += cpu[j][i];
      }
      value /= CPU_BUF_SIZE;
      cpu[CPU_BUF_SIZE][i] = value;
   }


   value = cpu[CPU_BUF_SIZE][4];
   n = (int)(value * 70.0);
   if (value >= 99.9) { sprintf(tmp, "100%%"); } 
   else { sprintf(tmp, "%4.1f%%", value); }
   sprintf(buffer, "widget_set C title {CPU LOAD %s}\n", tmp);
   if(display) sock_send_string(sock, buffer);
   
   value = cpu[CPU_BUF_SIZE][0];
   if (value >= 99.9) { sprintf(tmp, " 100%%"); } 
   else { sprintf(tmp, "%4.1f%%", value); }
   sprintf(buffer, "widget_set C usr 5 2 {%s}\n", tmp);
   if(display) sock_send_string(sock, buffer);
   
   value = cpu[CPU_BUF_SIZE][1];
   if (value >= 99.9) { sprintf(tmp, " 100%%"); } 
   else { sprintf(tmp, "%4.1f%%", value); }
   sprintf(buffer, "widget_set C sys 5 3 {%s}\n", tmp);
   if(display) sock_send_string(sock, buffer);
   
   value = cpu[CPU_BUF_SIZE][2];
   if (value >= 99.9) { sprintf(tmp, " 100%%"); } 
   else { sprintf(tmp, "%4.1f%%", value); }
   sprintf(buffer, "widget_set C nice 16 2 {%s}\n", tmp);
   if(display) sock_send_string(sock, buffer);
   
   value = cpu[CPU_BUF_SIZE][3];
   if (value >= 99.9) { sprintf(tmp, " 100%%"); } 
   else { sprintf(tmp, "%4.1f%%", value); }
   sprintf(buffer, "widget_set C idle 16 3 {%s}\n", tmp);
   if(display) sock_send_string(sock, buffer);
   
   value = cpu[CPU_BUF_SIZE][4];
   n = (int)(value * 70.0 / 100.0);
   sprintf(buffer, "widget_set C bar 3 4 %i\n", n);
   if(display) sock_send_string(sock, buffer);
   
   return 0;
} // End cpu_screen()



//////////////////////////////////////////////////////////////////////////
// Cpu Graph Screen shows a quick-moving histogram of CPU use.
//
int cpu_graph_screen(int rep, int display)
{
   int i, j, n=0;
   static int first=1;
   float value, maxload;
#undef CPU_BUF_SIZE
#define CPU_BUF_SIZE 2
   static float cpu[CPU_BUF_SIZE + 1];// last buffer is scratch
   static int cpu_past[LCD_MAX_WIDTH];
   struct load load;
   int status=0;
  

   if(first)
   {
      first = 0;
      sock_send_string(sock, "screen_add G\n");
      sock_send_string(sock, "screen_set G name {CPU Graph}\n");
      sock_send_string(sock, "widget_add G title title\n");
      sock_send_string(sock, "widget_set G title {CPU GRAPH}\n");
      for(i=1; i<=lcd_wid; i++)
      {
	 sprintf(tmp, "widget_add G %i vbar\n", i);
	 sock_send_string(sock, tmp);
	 sprintf(tmp, "widget_set G %i %i 4 0\n", i, i);
	 sock_send_string(sock, tmp);
      }
   }
   
   get_load(&load);

   // Shift values over by one
   for(i=0; i<(CPU_BUF_SIZE-1); i++)
      cpu[i] = cpu[i+1];
   
   // Read new data
   cpu[CPU_BUF_SIZE-1] = ((float)load.user + (float)load.system 
			  + (float)load.nice) / (float)load.total;


   // Only clear on first display...
   if(!rep)
   {
      /*
      // Make all the same, if this is the first time...
      for(i=0; i<CPU_BUF_SIZE-1; i++)
	 cpu[i] = cpu[CPU_BUF_SIZE-1];
      */
   }


   // Average values for final result
   value = 0;
   for(j=0; j<CPU_BUF_SIZE; j++)
   {
      value += cpu[j];
   }
   value /= (float)CPU_BUF_SIZE;
   cpu[CPU_BUF_SIZE] = value;


   maxload=0;
   for(i=0; i<lcd_wid-1; i++)
   {
      cpu_past[i] = cpu_past[i+1];

      j = cpu_past[i];
      sprintf(tmp, "widget_set G %i %i 4 %i\n",
	      i+1, i+1, j);
      if(display) sock_send_string(sock, tmp);

      if(cpu_past[i] > maxload) maxload = cpu_past[i];
   }

   value = cpu[CPU_BUF_SIZE];
   n = (int)(value * 8.0 * (float)(lcd_hgt-1));

   cpu_past[lcd_wid-1] = n;
   sprintf(tmp, "widget_set G %i %i 4 %i\n",
	   lcd_wid, lcd_wid, n);
   if(display) sock_send_string(sock, tmp);



   if(n > maxload) maxload = n;
   
   if(cpu_past[lcd_wid-1] > 0 ) status = BACKLIGHT_ON;  
   if(maxload < 1) status = BACKLIGHT_OFF;

//  return status;
   return 0;
} // End cpu_graph_screen()


