/* Driver module for Hitachi HD44780 based Optrex DMC-20481 LCD display 
 * The module is operated in it's 4 bit-mode to be connected to a single
 * 8 bit-port
 *
 * Copyright (c) 1998 Richard Rognlie       GNU Public License  
 *                    <rrognlie@gamerz.net>
 *
 * Large quantities of this code lifted (nearly verbatim) from
 * the lcd4.c module of lcdtext.  Copyright (C) 1997 Matthias Prinke
 * <m.prinke@trashcan.mcnet.de> and covered by GNU's GPL.
 * In particular, this program is free software and comes WITHOUT
 * ANY WARRANTY.
 *
 * Matthias stole (er, adapted) the code from the package lcdtime by
 * Benjamin Tse (blt@mundil.cs.mu.oz.au), August/October 1995
 * which uses the LCD-controller's 8 bit-mode.
 * References: port.h             by <damianf@wpi.edu>
 *             Data Sheet LTN211, Philips
 *             Various FAQs and TXTs about Hitachi's LCD Controller HD44780 -
 *                www.paranoia.com/~filipg is a good starting point  ???   
 */

#ifndef PICANLCD_H
#define PICANLCD_H


int picanlcd_init(char *device);
void picanlcd_close();
void picanlcd_clear();
void picanlcd_flush_box(int lft, int top, int rgt, int bot);
void picanlcd_contrast(int contrast);
void picanlcd_backlight(int on);
void picanlcd_init_vbar();
void picanlcd_init_hbar();
void picanlcd_vbar(int x, int len);
void picanlcd_hbar(int x, int y, int len);
void picanlcd_init_num();
void picanlcd_num(int x, int num);
void picanlcd_set_char(int n, char *dat);
void picanlcd_icon(int which, char dest);
void picanlcd_draw_frame(char *dat);

#endif
