#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <sys/time.h>
#include <termios.h>
#include <errno.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>

#include "main.h"
#include "lcd.h"
#include "mode.h"
#include "lock.h"


// TODO: Commenting...  Everything!


char version[] = "v0.3.1";
char build_date[] = "1998-04-21";
int Quit = 0;

/*
  Mode List:
  	U	Uptime
  	X	Xload
  	C	CPU usage
  	T	Time
  	M	Memory Use
  	A	About... (Credits)

	G ?	Fast cpu usage screen...  	
// TODO: Document the graph screen...
*/

typedef struct mode {
  char which;
  int num_times;
  int delay_time;
} mode;

void HelpScreen();
void exit_program(int val);
void main_loop(mode *sequence);

#define MAX_SEQUENCE 256
// 1/8th second is a single time unit...
#define TIME_UNIT 125000


mode default_sequence[] = 
{
  { 'C', 32,  1,  },
  { 'M', 8,   4,  },
  { 'T', 8,   4,  },
  { 'U', 8,   4,  },
  { 'X', 1,   32, },
  { 'A', 1,   16, },
  {  1 , 0,   0,  },// Modes after this line will not be run by default...
  { 'G', 32,  1,  },
  { 0,	0,    0,  },
};

// TODO: Clean up main()...  It's still way too big.

// FIXME: Improve lock file / process detection
// FIXME: Get shutdown to work when killed by init!
// TODO: Inter-process communication...
// TODO: Config file; not just command line


int main(int argc, char **argv)
{
  char device[256] = "/dev/lcd";
  char cfgfile[256] = "/etc/lcdproc.cf";
  mode sequence[MAX_SEQUENCE];
  int i, j, k;
  int already_running = 0;
  int contrast = 140;
  int tmp;

  memset(sequence, 0, sizeof(mode) * MAX_SEQUENCE);

  // Ctrl-C and "kill" will cause a clean exit...  :)
  signal(SIGINT, exit_program);
  signal(SIGTERM, exit_program);
  
  // Check to see if we're already running...
  already_running = CheckForLock();
  
  // Communicate with the previously running LCDproc
  if(already_running)
  {
    // "already_running" holds the pid of the LCDproc we want to talk to...

    // Do the command line  ("lcd pet status", or "lcd contrast 50")
    // And stuff...
    // ...Then exit
    printf("Detected another LCDproc.  (%i)  Exiting...\n", already_running);
    // Remove me ^^^^
    return 0;
  }

  // Command line
  memcpy(sequence, default_sequence, sizeof(default_sequence));
  for(i=1, j=0; i<argc; i++)
  {
    if(argv[i][0] == '-') switch(argv[i][1])
    {
      // "C is for cookie (erm, contrast), and that's good enough for me..."
      case 'C': 
      case 'c': if(argc < i+1) HelpScreen();
                contrast = atoi(argv[++i]);
                if(contrast <= 0) HelpScreen();
                break;
      // D for Device...
      case 'D': 
      case 'd': if(argc < i+1) HelpScreen();
                strcpy(device, argv[++i]);
                break;
      // otherwise...  Get help!
      default: HelpScreen(); break;
    }
    // Parse command line here...  read the man page.
    else if(strlen(argv[i]) == 1)
    {
      // Grab the mode letter...
      sequence[j].which = argv[i][0];

      // If we have just a letter with no numbers...
      // Set the defaults...
      for(tmp=0, k=0; default_sequence[k].which; k++)
      {
        if(toupper(sequence[j].which == default_sequence[k].which))
        {
           memcpy(&sequence[j], &default_sequence[k], sizeof(mode));
           tmp=1;
           break;
        }
      }
      if(!tmp) { printf("Invalid Mode: %c\n", argv[i][0]); exit(0); }

      j++;
      // Set the last element to 0...
      memset(sequence + j, 0, sizeof(mode));
    } // End if(strlen(argv == 1))
    else
    {
      // A multicharacter parameter by itself is assumed to be a config file..
      strcpy(cfgfile, argv[i]);
      printf("Ignoring config file: %s\n", cfgfile);
    }
  }

  // Init the com port
  if(lcd_init(device) < 1) 
  {
    printf("Can't initialize %s.\n", device);
    exit(1);
  }
  mode_init();
  lcd_contrast(contrast);

  main_loop(sequence);
  
  // Clean up
  exit_program(0);
  return 0;
}


void HelpScreen()
{
  printf("LCDproc, %s\n", version);
  printf("Usage: lcdproc [-d device] [-c contrast] [modelist]\n");
  printf("\tOptions in []'s are optional.\n");
  printf("\t-d device is what the lcd display is hooked to. (/dev/cua0?)\n");
  printf("\t-c contrast sets the screen contrast (0 - 255)\n");
  printf("\tmodelist is \"mode [seconds frequency]\"\n");
  printf("\tMode letters are: [C]pu [T]ime [M]emory [X]load [U]ptime [A]bout\n");
  printf("\tSeconds specifies how long to show each screen, and\n");
  printf("\tFrequency specifies how often to update the screen.\n");
  printf("\n");
  printf("\tUse \"man lcdproc\" for more info.\n");
  printf("Example:\n");
  printf("\tlcdproc c 4 .25 -d /dev/cua1 x 4 4\n");
  printf("\n");
  printf("Uses com2 and displays cpu screen every .25 seconds for 4 seconds,\n");
  printf("then shows the xload screen once for 4 seconds.\n");
  printf("\n");
  exit(0);
}


///////////////////////////////////////////////////////////////////
// Called upon TERM and INTR signals...
//
void exit_program(int val)
{
  Quit = 1;
  unlock();
  goodbye_screen(0);
  lcd_backlight(1);
  lcd_close();
  mode_close();
  exit(0);
}


///////////////////////////////////////////////////////////////////
// Main program loop...
//
void main_loop(mode *sequence)
{
  int i, j, k;
  int Quit=0;
  int status=0;
  int timer=0;

  int blink=0;

  // Main loop
  // Run whatever screen we want, then wait.  Woo-hoo!
  for(i=0; !Quit; )
  {
    timer=0;
    for(j=0; j<sequence[i].num_times && !Quit; j++)
    {
      switch(sequence[i].which)
      {
	case 'g':
	case 'G': status = cpu_graph_screen(j); break;
        case 'c':
        case 'C': status = cpu_screen(j); break;
        case 't':
        case 'T': status = clock_screen(j); break;
        case 'm':
        case 'M': status = mem_screen(j); break;
        case 'u':
        case 'U': status = uptime_screen(j); break;
        case 'x':
        case 'X': status = xload_screen(j); break;
        case 'a':
        case 'A': status = credit_screen(j); break;
        default: status = dumbass_screen(j); break;
      }
      for(k=0; k<sequence[i].delay_time; k++)
      {
        usleep(TIME_UNIT);  timer++;
        // Modify lcd status here...  (blinking, for example)
        switch(status)
        {
          case BLINK_ON : blink=1; break;
          case BLINK_OFF: blink=0; lcd_backlight(1); break;
          case BACKLIGHT_OFF: blink=0; lcd_backlight(0); break;
          case BACKLIGHT_ON : blink=0; lcd_backlight(1); break;
        }
        if(blink) lcd_backlight(! (timer&4));
      }
    }
    i++;
    if(sequence[i].which < 2) i=0;
  }
}
