#include <sys/types.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include "lock.h"


#define LOCKFILE "/tmp/lcdproc.lock"

/////////////////////////////////////////////////////////////////////
// Checks to see if another LCDproc is running, and returns its pid if so.
// If one isn't running, it creates a lockfile and returns 0.
//
int CheckForLock()
{
  char lockfile[] = LOCKFILE;
  char procfile[64];
  FILE *lock, *proc=NULL;
  int running = 1;
  char tmp[256];
  pid_t mypid, yourpid=0;


  // Get our pid...
  mypid = getpid();
  
  // Check to see if the file exists...
  lock = fopen(lockfile, "r");

  // If the file doesn't exist, it's not running.
  if(!lock) running = 0;
  // If it does exist, we must check to see if it holds a valid process id.
  else
  {
    // Grab a pid from the file
    fgets(tmp, sizeof(tmp), lock);
    yourpid = atoi(tmp);
    
    // If it's *our* pid, assume we're alone...
    if(yourpid == mypid) running = 0;
    
    // If the number is invalid, assume we're alone...
    else if(yourpid < 1) running = 0;
    else
    {
      sprintf(procfile, "/proc/%i/cmdline", yourpid);
      proc = fopen(procfile, "r");
      if(!proc)  running = 0;
      else  running = 1;
    }
  }


  if(lock) fclose(lock);
  if(proc) fclose(proc);

  if(running)
  {
    return yourpid;
  }

  else	// Must not be running yet...
  {
    // Create a lockfile...
    lock = fopen(LOCKFILE, "w");
    if(!lock) 
    {
      printf("Can't create lock file.  Exiting.\n");
      return -1;
    }
    else
    {
      sprintf(tmp, "%i", mypid);
      fputs(tmp, lock);
      fclose(lock);
    }
  }

  return 0;
}


///////////////////////////////////////////////////////////////////////////
// Removes the lock file created earlier
//
void unlock()
{
  if(remove(LOCKFILE) != 0)
  {
    printf("Error removing lockfile: ");
    switch(errno)
    {
      case EACCES: printf("Access Denied\n"); break;
      case EBUSY : printf("File Busy\n"); break;
      case ENOENT: printf("File not found\n"); break;
      case EROFS : printf("Read-only Filesystem\n"); break;
      default: printf("\n"); break;
    }
  }
}
