#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/errno.h>
#include "lcd.h"


// TODO: Add DOS/Windows support...

// TODO: Logical LCD interface, for multiple driver support...

#ifndef NOLCD

static int fd;

int lcd_init(char *device) 
{
  struct termios portset;

  fd = open(device, O_RDWR | O_NOCTTY | O_NDELAY); 
  if (fd == -1) 
  {
    fprintf(stderr, "lcd_init: failed (%s)\n", strerror(errno)); 
  }
  tcgetattr(fd, &portset);
  cfmakeraw(&portset);
  cfsetospeed(&portset, B19200);
  tcsetattr(fd, TCSANOW, &portset);

  lcd_clear();
  lcd_contrast(180);

  return fd;
}

void lcd_close() 
{
  close (fd); 
}

void lcd_clear() 
{
  write(fd, "\xFEX", 2);
}

void lcd_contrast(int contrast) 
{
  char out[4];
  sprintf(out, "%cP%c", 254, contrast);
  write(fd, out, 3);
}

void lcd_backlight(int on)
{
  char out[4];
  if(on)
  {
    sprintf(out, "%cB%c", 254, 0);
    write(fd, out, 3);
  }
  else
  {
    sprintf(out, "%cF", 254);
    write(fd, out, 2);
  }
}

/////////////////////////////////////////////////////////////////
// Prints a string on the lcd display, at position (x,y).  The
// upper-left is (1,1), and the lower right should be (20,4).
//
void lcd_string(int x, int y, char lcd[]) 
{
  char out[64];
  sprintf(out, "%cG%c%c%s", 254, x, y, lcd);
  write(fd, out, strlen(out));
}

void lcd_init_vbar() 
{
  char out[3];
  sprintf(out, "%cv", 254);
  write(fd, out, 2);
}

void lcd_vbar(int x, int len) 
{
  char out[5];
  sprintf(out, "%c=%c%c", 254, x, len);
  write(fd, out, 4);
}

void lcd_hbar(int x, int y, int len) 
{
  char out[10];
  sprintf(out, "%c|%c%c%c%c", 254, x, y, 0, len);
  write(fd, out, 6); 
}

void lcd_init_hbar() 
{
  char out[3];
  sprintf(out, "%ch", 254);
  write(fd, out, 2);
}

void lcd_init_num() 
{
  char out[3];
  sprintf(out, "%cn", 254);
  write(fd, out, 2);
}

void lcd_num(int x, int num) 
{
  char out[5];
  sprintf(out, "%c#%c%c", 254, x, num);
  write(fd, out, 4);
}



#else
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

static int fd;

int lcd_init(char *device) 
{
  fd = 200;
  return fd;
}

void lcd_close() 
{
}

void lcd_clear() 
{
  printf("Clear\n");
}

void lcd_contrast(int contrast) 
{
  printf("Contrast: %i\n", contrast);
}

void lcd_backlight(int on)
{
  if(on)
  {
    printf("Backlight ON\n");
  }
  else
  {
    printf("Backlight OFF\n");
  }
}


/////////////////////////////////////////////////////////////////
// Prints a string on the lcd display, at position (x,y).  The
// upper-left is (1,1), and the lower right should be (20,4).
//
void lcd_string(int x, int y, char lcd[]) 
{
  printf("print(%i, %i): %s\n", x, y, lcd);
}

void lcd_init_vbar() 
{
  printf("Vertical bars.\n");
}

void lcd_vbar(int x, int len) 
{
  printf("Vbar(%i, %i)\n", x, len);
}

void lcd_hbar(int x, int y, int len) 
{
  printf("Hbar(%i, %i, %i)\n", x, y, len);
}

void lcd_init_hbar() 
{
  printf("Horizontal bars.\n");
}

void lcd_init_num() 
{
  printf("Big Numbers.\n");
}

void lcd_num(int x, int num) 
{
  printf("BigNum(%i, %i)\n", x, num);
}

#endif
